app_driver_tm_a_regression <- function() {
  data <- within(teal.data::teal_data(), {
    require(nestcolor)
    CO2 <- CO2 # nolint: object_name.
  })

  init_teal_app_driver(
    data = data,
    modules = tm_a_regression(
      label = "Regression",
      response = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = "uptake",
          selected = "uptake",
          multiple = FALSE,
          fixed = TRUE
        )
      ),
      regressor = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variables:",
          choices = teal.transform::variable_choices(data[["CO2"]], c("conc", "Treatment")),
          selected = "conc",
          multiple = TRUE,
          fixed = FALSE
        )
      ),
      plot_height = c(600, 200, 2000),
      plot_width = NULL,
      alpha = c(1, 0, 1),
      size = c(2, 1, 8),
      ggtheme = c("gray", "bw", "linedraw", "light", "dark", "minimal", "classic", "void"),
      pre_output = NULL,
      post_output = NULL,
      default_plot_type = 3,
      default_outlier_label = "USUBJID",
      label_segment_threshold = c(0.5, 0, 10),
      ggplot2_args = teal.widgets::ggplot2_args(
        labs = list(subtitle = "Plot generated by Regression Module")
      )
    )
  )
}

testthat::test_that("e2e - tm_a_regression: Data parameter and module label is passed properly.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()
  app_driver$expect_no_shiny_error()

  testthat::expect_equal(
    app_driver$get_text("#teal-teal_modules-active_tab .active"),
    "Regression"
  )

  encoding_dataset <- app_driver$get_text("#teal-teal_modules-regression .help-block")
  testthat::expect_match(encoding_dataset, "Dataset:[\n ]*CO2", all = FALSE)

  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression:
  Data extract spec elements are initialized with the default values specified by response and regressor arg.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  testthat::expect_identical(
    app_driver$active_module_element_text("response-dataset_CO2_singleextract-select_selected_text"),
    "uptake"
  )

  testthat::expect_identical(
    app_driver$get_active_module_input("regressor-dataset_CO2_singleextract-select"),
    "conc"
  )
  app_driver$set_active_module_input("regressor-dataset_CO2_singleextract-select", "Treatment")

  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression: Plot type is set properly.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  testthat::expect_identical(
    app_driver$get_active_module_input("plot_type"),
    "Normal Q-Q"
  )
  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression:
  Plot type has 7 specific choices & changing choices does not throw errors.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  plot_types <- app_driver$active_module_element_text("plot_type > div")

  possible_choices <-
    c(
      "Response vs Regressor", "Scale-Location", "Residuals vs Leverage",
      "Residuals vs Fitted", "Normal Q-Q", "Cook's distance", "Cook's dist vs Leverage"
    )

  invisible(
    lapply(
      possible_choices,
      function(choice) {
        expect_match(plot_types, choice, fixed = TRUE)
        app_driver$set_active_module_input("plot_type", choice)
        app_driver$expect_no_validation_error()
      }
    )
  )

  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression: Outlier definition and label are visible by default.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  testthat::expect_true(app_driver$get_active_module_input("show_outlier"))
  testthat::expect_true(app_driver$is_visible(app_driver$active_module_element("outlier-label")))
  testthat::expect_true(app_driver$is_visible(app_driver$active_module_element("label_var_input")))

  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression: Outlier definition and label have default values and label text.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  testthat::expect_match(
    app_driver$active_module_element_text("label_var_input"),
    "Outlier label",
    fixed = TRUE
  )
  outlier_label <- app_driver$active_module_element_text("outlier-label")
  testthat::expect_match(
    outlier_label,
    "Outlier definition:",
    fixed = TRUE
  )
  testthat::expect_match(
    outlier_label,
    "distance greater than the value on the slider times the mean of the Cook",
    fixed = TRUE
  )

  testthat::expect_identical(app_driver$get_active_module_input("label_var"), "uptake")
  testthat::expect_identical(app_driver$get_active_module_input("outlier"), 9L)

  app_driver$stop()
})

testthat::test_that("e2e - tm_a_regression: Unchecking display outlier hides outlier label and definition.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_a_regression()

  app_driver$set_active_module_input("show_outlier", FALSE)
  testthat::expect_false(app_driver$is_visible(app_driver$active_module_element("outlier-label")))
  testthat::expect_false(app_driver$is_visible(app_driver$active_module_element("label_var_input")))

  app_driver$expect_no_validation_error()

  app_driver$stop()
})
