% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PictureBlock.R
\docType{class}
\name{PictureBlock}
\alias{PictureBlock}
\title{\code{PictureBlock}}
\description{
Specialized \code{FileBlock} for managing picture content in reports.
It's designed to handle plots from packages such as \code{ggplot2}, \code{grid}, or \code{lattice}.
It can save plots to files, set titles and specify dimensions.
}
\examples{
\dontshow{if (require("ggplot2") && require("lattice")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(lattice)

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_content(ggplot(iris))

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_content(bwplot(1))

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_content(ggplotGrob(ggplot(iris)))
\dontshow{\}) # examplesIf}

## ------------------------------------------------
## Method `PictureBlock$set_title`
## ------------------------------------------------

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_title("Title")


## ------------------------------------------------
## Method `PictureBlock$get_title`
## ------------------------------------------------

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$get_title()


## ------------------------------------------------
## Method `PictureBlock$set_dim`
## ------------------------------------------------

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_dim(c(800, 600))


## ------------------------------------------------
## Method `PictureBlock$get_dim`
## ------------------------------------------------

PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$get_dim()
}
\keyword{internal}
\section{Super classes}{
\code{\link[teal.reporter:ContentBlock]{teal.reporter::ContentBlock}} -> \code{\link[teal.reporter:FileBlock]{teal.reporter::FileBlock}} -> \code{PictureBlock}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PictureBlock-new}{\code{PictureBlock$new()}}
\item \href{#method-PictureBlock-set_content}{\code{PictureBlock$set_content()}}
\item \href{#method-PictureBlock-set_title}{\code{PictureBlock$set_title()}}
\item \href{#method-PictureBlock-get_title}{\code{PictureBlock$get_title()}}
\item \href{#method-PictureBlock-set_dim}{\code{PictureBlock$set_dim()}}
\item \href{#method-PictureBlock-get_dim}{\code{PictureBlock$get_dim()}}
\item \href{#method-PictureBlock-clone}{\code{PictureBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="get_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-get_content'><code>teal.reporter::ContentBlock$get_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileBlock" data-id="from_list"><a href='../../teal.reporter/html/FileBlock.html#method-FileBlock-from_list'><code>teal.reporter::FileBlock$from_list()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileBlock" data-id="to_list"><a href='../../teal.reporter/html/FileBlock.html#method-FileBlock-to_list'><code>teal.reporter::FileBlock$to_list()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-new"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{PictureBlock} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$new(plot)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{(\code{ggplot} or \code{grid}) a picture in this \code{PictureBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{PictureBlock}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-set_content"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-set_content}{}}}
\subsection{Method \code{set_content()}}{
Sets the content of this \code{PictureBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$set_content(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{ggplot} or \code{grob} or \code{trellis}) a picture in this \code{PictureBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Raises error if argument is not a \code{ggplot}, \code{grob} or \code{trellis} plot.
}

\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-set_title"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-set_title}{}}}
\subsection{Method \code{set_title()}}{
Sets the title of this \code{PictureBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$set_title(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{(\code{character(1)}) a string assigned to this \code{PictureBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Raises error if argument is not \code{character(1)}.
}

\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_title("Title")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-get_title"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-get_title}{}}}
\subsection{Method \code{get_title()}}{
Get the title of this \code{PictureBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$get_title()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The content of this \code{PictureBlock}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$get_title()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-set_dim"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-set_dim}{}}}
\subsection{Method \code{set_dim()}}{
Sets the dimensions of this \code{PictureBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$set_dim(dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{(\code{numeric(2)}) figure dimensions (width and height) in pixels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$set_dim(c(800, 600))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-get_dim"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-get_dim}{}}}
\subsection{Method \code{get_dim()}}{
Get \code{PictureBlock} dimensions as a numeric vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$get_dim()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{numeric} the array of 2 numeric values representing width and height in pixels.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{PictureBlock <- getFromNamespace("PictureBlock", "teal.reporter")
block <- PictureBlock$new()
block$get_dim()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PictureBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PictureBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PictureBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
