% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_gbw}
\alias{.get_gbw}
\title{g_bw: Boundary layer conductance to water vapour (m / s)}
\usage{
.get_gbw(T_leaf, surface, pars, unitless)
}
\arguments{
\item{T_leaf}{Leaf temperature in Kelvin}

\item{surface}{Leaf surface (lower or upper)}

\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in m / s of class \code{units}
}
\description{
g_bw: Boundary layer conductance to water vapour (m / s)
}
\details{
\deqn{g_\mathrm{bw} = D_\mathrm{w} Sh / d}{g_bw = D_w Sh / d}

\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{d} \tab \code{leafsize} \tab Leaf characteristic dimension in meters \tab m \tab 0.1\cr
\eqn{D_\mathrm{w}}{D_w} \tab \code{D_w} \tab diffusion coefficient for water vapour \tab m\eqn{^2} / s \tab \link[=.get_Dx]{calculated}\cr
\eqn{Sh} \tab \code{Sh} \tab Sherwood number \tab none \tab \link[=.get_sh]{calculated}
}
}
\examples{

library(tealeaves)

cs <- make_constants()
ep <- make_enviropar()
lp <- make_leafpar()

T_leaf <- set_units(298.15, K)

tealeaves:::.get_gbw(T_leaf, "lower", c(cs, ep, lp), FALSE)

}
