% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_statistics.R
\name{rolling_test}
\alias{rolling_test}
\alias{roll_normchisq}
\alias{roll_rayleigh}
\alias{roll_dispersion}
\alias{roll_confidence}
\alias{roll_dispersion_CI}
\alias{roll_dispersion_sde}
\title{Apply Rolling Functions using Circular Statistical Tests for Uniformity}
\usage{
roll_normchisq(
  obs,
  prd,
  unc = NULL,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)

roll_rayleigh(
  obs,
  prd,
  unc = NULL,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)

roll_dispersion(
  x,
  y,
  w = NULL,
  w.y = NULL,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)

roll_confidence(
  x,
  conf.level = 0.95,
  w = NULL,
  axial = TRUE,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)

roll_dispersion_CI(
  x,
  y,
  w = NULL,
  w.y = NULL,
  R,
  conf.level = 0.95,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)

roll_dispersion_sde(
  x,
  y,
  w = NULL,
  w.y = NULL,
  R,
  conf.level = 0.95,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)
}
\arguments{
\item{obs}{Numeric vector containing the observed azimuth of
\eqn{\sigma_{Hmax}}{SHmax},
same length as \code{prd}}

\item{prd}{Numeric vector containing the modeled azimuths of
\eqn{\sigma_{Hmax}}{SHmax}, i.e.
the return object from \code{model_shmax()}}

\item{unc}{Uncertainty of observed \eqn{\sigma_{Hmax}}{SHmax}, either a
numeric vector or a number}

\item{width}{integer specifying the window width (in numbers of observations)
which is aligned to the original sample according to the \code{align} argument.
If \code{NULL}, an optimal width is estimated.}

\item{by.column}{logical. If \code{TRUE}, FUN is applied to each column separately.}

\item{partial}{logical or numeric. If \code{FALSE} then \code{FUN} is only
applied when all indexes of the rolling window are within the observed time
range. If \code{TRUE} (default), then the subset of indexes that are in range
are passed to \code{FUN}. A numeric argument to partial can be used to determine
the minimal window size for partial computations. See below for more details.}

\item{fill}{a three-component vector or list (recycled otherwise) providing
filling values at the left/within/to the right of the data range. See the
fill argument of \code{\link[zoo:na.fill]{zoo::na.fill()}} for details}

\item{...}{optional arguments passed to \code{\link[zoo:rollapply]{zoo::rollapply()}}}

\item{x, y}{numeric. Directions in degrees}

\item{w, w.y}{(optional) Weights of \code{x} and \code{y}, respectively. A vector of positive numbers and of the same
length as \code{x}.}

\item{conf.level}{Level of confidence: \eqn{(1 - \alpha \%)/100}.
(\code{0.95} by default).}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{R}{The number of bootstrap replicates.}
}
\value{
numeric vector with the test statistic of the rolling test.
\code{roll_dispersion_CI} returns a 2-column matrix with the lower and the upper confidence limits
}
\description{
A generic function for applying a function to rolling margins of an array.
}
\note{
If the rolling functions are applied to values that are a function of
distance it is recommended to sort the values first.
}
\examples{
data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")
data("san_andreas")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
distance <- distance_from_pb(
  x = san_andreas,
  PoR = PoR,
  pb = plate_boundary,
  tangential = TRUE
)
dat <- san_andreas[order(distance), ]
dat.PoR <- PoR_shmax(san_andreas, PoR, "right")
roll_normchisq(dat.PoR$azi.PoR, 135, dat$unc)
roll_rayleigh(dat.PoR$azi.PoR, prd = 135, unc = dat$unc)
roll_dispersion(dat.PoR$azi.PoR, y = 135, w = 1 / dat$unc)
roll_confidence(dat.PoR$azi.PoR, w = 1 / dat$unc)
\donttest{
roll_dispersion_CI(dat.PoR$azi.PoR, y = 135, w = 1 / dat$unc, R = 10)
}
}
