% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{prd_err}
\alias{prd_err}
\title{Error of Model's Prediction}
\usage{
prd_err(dist_PoR, sigma_PoR = 1)
}
\arguments{
\item{dist_PoR}{Distance to Euler pole (great circle distance, in degree)}

\item{sigma_PoR}{uncertainty of the position of the Pole of rotation
(in degree).}
}
\value{
numeric vector. The maximum error for azimuths prediction (in degree)
}
\description{
The maximum error in the model's predicted azimuth given the Pole of
rotations uncertainty and distance of the data point to the pole.
}
\examples{
prd_err(67, 1)
}
\references{
Ramsay, J.A. Folding and fracturing of rocks. McGraw-Hill, New York, 1967.
}
\seealso{
\code{\link[=PoR_shmax]{PoR_shmax()}} and \code{\link[=model_shmax]{model_shmax()}} for the model's prediction, and
\code{\link[=orthodrome]{orthodrome()}} for great circle distances.
}
