% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stFit.R
\name{stFit}
\alias{stFit}
\title{Fit the remote effects spatial process (RESP) model}
\usage{
stFit(stData = NULL, priors, maxIt, X = stData$X, Y = stData$Y,
  Z = stData$Z, coords.s = stData$coords.s, coords.r = stData$coords.r,
  rw.initsd = NULL, returnll = T, miles = T, C = 1, alpha = 0.44,
  localOnly = F, varying = F, remoteOnly = F, coords.knots)
}
\arguments{
\item{stData}{Object with class 'stData' containing data needed to fit this 
model. The data need only be manually entered if not using a stData object.}

\item{priors}{A list containing parameters for the prior distributions. The
list needs to contain the following values:
  \describe{
    \item{beta}{ list(Lambda=matrix) specifying the prior covariance matrix
      for the local effects if varying==F, otherwise 
      list(Psi=matrix, nu=double) specifying the Inverse wishart prior 
      distribution for the spatially varying coefficient process if 
      varying==T. }
    
    \item{cov.s}{ list(smoothness=double, range=c(min, max), 
      variance=c(shape, rate), nugget=c(shape, rate)) }
      
    \item{cov.r}{ list(smoothness=double, range=c(min, max), 
      variance=c(shape, rate), nugget=c(shape, rate)) }
  }}

\item{maxIt}{number of iterations to run the MCMC chain for}

\item{X}{[ns, p, nt] array of design matrices with local covariates}

\item{Y}{[ns, nt] matrix with response data}

\item{Z}{[nr, nt] matrix with remote covariates}

\item{coords.s}{matrix with coordinates where responses were 
observed (lon, lat)}

\item{coords.r}{matrix with coordinates where remote covariates
were observed (lon, lat)}

\item{rw.initsd}{A list containing initial standard deviation parameters for
the MCMC parameters requiring random walk updates:
  \describe{
    \item{cov.s}{ list(range=double, nugget=double) }
    \item{cov.r}{ list(range=double, variance=double, nugget=double) }
  }}

\item{returnll}{TRUE to compute the model log-likelihood at each iteration}

\item{miles}{TRUE if covariance matrix distances should be in miles, FALSE 
for kilometers}

\item{C}{scaling factor used in adapting random walk proposal variances.}

\item{alpha}{target acceptance rate for random walk proposals.}

\item{localOnly}{TRUE to fit the model without the teleconnection effects
(typically for evaluating impact of teleconnection effects)}

\item{varying}{(depreceated) TRUE to fit the model with spatially varying local coefficients}

\item{remoteOnly}{TRUE to fit the model without local effects.  This will 
fit a local intercept, but will not incorporate local covariates.}

\item{coords.knots}{matrix with coordinates where remote teleconnections
will be based (lon, lat)}
}
\description{
Fit the remote effects spatial process (RESP) model
}
\examples{
library(dplyr)
library(foreach)
library(itertools)

set.seed(2018)

data("coprecip")
data("coprecip.fit")
attach(coprecip)

coprecip.fit = stFit(stData = coprecip, priors = coprecip.fit$priors, 
                     maxIt = 10, coords.knots = coprecip.fit$coords.knots)
}
