% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{tds.plot}
\alias{tds.plot}
\title{Plot TDS curves}
\usage{
tds.plot(X, attributes = NULL, times = NULL, chance = NULL, signif = NULL,
 line.col = 1, lty = 1, lwd = 1, xlab = "Time (seconds)", ylab = "Dominance (rate)",
 main = "", height = 8, width = 12, save.as = "")
}
\arguments{
\item{X}{matrix of dominance rates (Attributes in rows, Times in columns).}

\item{attributes}{a vector of attribute labels, corresponding to the attributes in \code{X}.}

\item{times}{a vector of times, corresponding to the times in \code{X}.}

\item{chance}{proportion indicating the chance level, usually \code{1/length(attributes)} or \code{1/(1+length(attributes))}.}

\item{signif}{significance level associated with the number of observations and \code{chance}.}

\item{line.col}{A vector of colors for lines corresponding to \code{attributes}; see \code{\link[graphics]{par}}}

\item{lty, lwd}{line type and weight for attributes; see \code{\link[graphics]{par}}}

\item{xlab, ylab}{Labels for the x and y axes; see \code{\link[graphics]{plot}}}

\item{main}{plot title; see \code{\link[graphics]{plot}}}

\item{height}{Window height.}

\item{width}{Window width.}

\item{save.as}{Filename if the file will be saved.}
}
\description{
Plots TDS curves based on dominance rates, showing chance and significance lines.
}
\examples{
# example using 'bars' data set
bars.m <- aggregate(bars[, -c(1:4)], list(samples = bars$sample, attribute = bars$attribute), mean)
bars.m <- bars.m[order(bars.m$sample, bars.m$attribute), ]
attributes <- unique(bars$attribute)
times <- get.times(colnames(bars.m)[-c(1:2)])
chance <- get.chance(attributes)
signif <- get.significance(chance, nrow(unique(bars[, 1:2])))
tds.plot(get.smooth(bars.m[bars.m$sample == 1, -c(1:2)]), attributes = attributes,
         times = times, chance = chance, signif = signif,
         lwd = 2, main = "Bar 1")
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal Dominance of Sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

