% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.r, R/dtensor-math.r,
%   R/sptensor-math.r
\docType{methods}
\name{ttv}
\alias{ttv}
\alias{ttv,dtensor,numeric,numeric-method}
\alias{ttv,dtensor,numeric,numeric,numeric-method}
\alias{ttv,sptensor,numeric,numeric-method}
\alias{ttv,sptensor,numeric,numeric,numeric-method}
\alias{ttv,sptensor,sparseVector,numeric-method}
\alias{ttv,sptensor,numeric,numeric,numeric-method}
\title{Tensor times vector}
\usage{
ttv(x, v, mode)

\S4method{ttv}{dtensor,numeric,numeric}(x, v, mode)

\S4method{ttv}{sptensor,numeric,numeric}(x, v, mode)

\S4method{ttv}{sptensor,sparseVector,numeric}(x, v, mode)
}
\arguments{
\item{x}{tensor}

\item{v}{vector}

\item{mode}{mode along tensor to perform multiplication}
}
\description{
Calculates the n-mode product of a tensor and a vector Given a tensor X with
dimensions \eqn{I_1, I_2, ..., I_n, I_n+1, ... I_N} and a vector v with
dimensions \eqn{J, 1}, the resulting tensor after multiplication will have
dimension \eqn{I_1, I_2, ..., I_n-1, I_n+1, ... I_N}. Note that the dimension
corresponding to the \code{mode} has been dropped.
}
\references{
\cite{T. G. Kolda and B. W. Bader, Tensor Decompositions and
Applications, SIAM Review 51(3):455-500, September 2009}
}
