% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_decompositions.R
\name{hooi}
\alias{hooi}
\title{Calculate the higher-order orthogonal iteration (HOOI).}
\usage{
hooi(X, r, tol = 10^-6, print_fnorm = FALSE)
}
\arguments{
\item{X}{An array of numerics.}

\item{r}{A vector of integers. This is the given low multilinear rank of the
approximation.}

\item{tol}{A numeric. Stopping criterion.}

\item{print_fnorm}{Should updates of the optimization procedure be printed?
This number should get larger during the optimizaton procedure.}
}
\value{
\code{G} An all-orthogonal core array.

  \code{U} A vector of matrices with orthonormal columns.
}
\description{
This function will calculate the best rank \code{r} (where \code{r} is a
vector) approximation (in terms of sum of squared differences) to a given
data array.
}
\details{
Given an array \code{X}, this code will find a core array \code{G} and a list
of matrices with orthonormal columns \code{U} that minimizes \code{fnorm(X -
atrans(G, U))}. If \code{r} is equal to the dimension of \code{X}, then it
returns the HOSVD (see \code{\link{hosvd}}).

For details on the HOOI see
\href{http://epubs.siam.org/doi/abs/10.1137/S0895479898346995}{Lathauwer et
al (2000)}.
}
\examples{
#Generate random data.
p <- c(2, 3, 4)
X <- array(stats::rnorm(prod(p)), dim = p)

#Calculate HOOI
r <- c(2, 2, 2)
hooi_x <- hooi(X, r = r)
G <- hooi_x$G
U <- hooi_x$U

#Reconstruct the hooi approximation.
X_approx <- atrans(G, U)
fnorm(X - X_approx)
}
\author{
David Gerard.
}
\references{
De Lathauwer, L., De Moor, B., & Vandewalle, J. (2000).
  \href{http://epubs.siam.org/doi/abs/10.1137/S0895479898346995}{On the best
  rank-1 and rank-(\eqn{r_1, r_2,..., r_n}) approximation of higher-order tensors}.
  \emph{SIAM Journal on Matrix Analysis and Applications}, 21(4), 1324-1342.
}
\keyword{decompositions}

