% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vld.R
\name{vld_term}
\alias{vld_term}
\title{Validate Term}
\usage{
vld_term(x, validate = "class")
}
\arguments{
\item{x}{The object to check.}

\item{validate}{A string specifying the level of the validation.
The possible values in order of increasing strictness
are 'class', 'valid', 'consistent' and 'complete'.}
}
\value{
A flag indicating whether the condition was met.
}
\description{
Validates the elements of a term vector.
}
\details{
Missing values are ignored as are duplicates and order.
}
\examples{
vld_term(c("x[2]", "x[1]"))
vld_term(as.term(c("x[2]", "x[1]")))
}
\seealso{
\code{\link[=chk_term]{chk_term()}}
}
