test_that("get_tiles gets the same hydro tiles twice", {
  skip_on_cran()
  skip_if_offline()
  dl_loc <- data.frame(
    lat = c(44.04905, 44.04911),
    lng = c(-74.01188, -74.01179)
  )
  dl_loc <- sf::st_as_sf(dl_loc, coords = c("lng", "lat"))
  sf::st_crs(dl_loc) <- sf::st_crs(4326)
  output_tif <- get_tiles(dl_loc,
    services = c("hydro", "nhd", "NHDPlus_HR"),
    georeference = FALSE
  )

  expect_equal(names(output_tif), c("hydro", "NHDPlus_HR"))

  expect_equal(length(output_tif), 2)
  expect_equal(length(output_tif[[1]]), 1)

  expect_equal(
    png::readPNG(output_tif[[1]]),
    png::readPNG("testdata/nhd.png")
  )

  expect_equal(
    png::readPNG(output_tif[[2]]),
    png::readPNG("testdata/NHDPlus_HR.png")
  )
})
