% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chi}
\alias{chi}
\alias{ggplot.chi}
\alias{plot.chi}
\alias{print.chi}
\alias{print.summary.chi}
\alias{summary.chi}
\title{Measures of extremal dependence}
\usage{
chi(data, nq = 100, qlim = NULL, alpha = 0.05, trunc = TRUE)

\method{summary}{chi}(object, ...)

\method{print}{summary.chi}(x, digits=3, ...)

\method{print}{chi}(x, ...)

\method{plot}{chi}(x, show=c("Chi"=TRUE,"ChiBar"=TRUE), lty=1,
cilty=2, col=1, spcases=TRUE, cicol=1, xlim=c(0, 1), ylimChi =
c(-1, 1), ylimChiBar = c(-1, 1), mainChi = "Chi", mainChiBar =
"Chi Bar", xlab = "Quantile", ylabChi =
expression(chi(u)), ylabChiBar = expression(bar(chi)(u)),
ask, ...)

\method{ggplot}{chi}(data=NULL, mapping, xlab = "Quantile", 
ylab=c("ChiBar" = expression(bar(chi)(u)), "Chi" = expression(chi(u))),
main=c("ChiBar" = "Chi Bar",       "Chi" = "Chi"),
xlim = c(0, 1), ylim =list("Chi" = c(-1, 1),"ChiBar" = c(-1, 1)),
ptcol="blue",fill="orange",show=c("ChiBar"=TRUE,"Chi"=TRUE),
spcases = TRUE,plot., ..., environment)
}
\arguments{
\item{data}{A matrix containing 2 numeric columns.}

\item{nq}{The number of quantiles at which to evaluate the dependence
measures.}

\item{qlim}{The minimum and maximum quantiles at which to do the evaluation.}

\item{alpha}{The size of the confidence interval to be used. Defaults to
\code{alpha = 0.05}.}

\item{trunc}{Logical flag indicating whether the estimates should be
truncated at their theoretical bounds.  Defaults to \code{trunc = TRUE}.}

\item{x, object}{An object of class \code{chi}.}

\item{digits}{Number of digits for printing.}

\item{show}{Logical, of length 2, names "Chi" and "ChiBar".  Defaults to\cr
\code{c("Chi" = TRUE, "ChiBar" = TRUE)}.}

\item{lty, cilty, col, cicol}{Line types and colours for the the estimated
quantities and their confidence intervals.}

\item{xlim, ylimChi, ylimChiBar}{Limits for the axes.}

\item{mainChi, mainChiBar}{Main titles for the plots.}

\item{xlab, ylabChi, ylabChiBar}{Axis labels for the plots.}

\item{mapping, ylab, main, ylim, ptcol, fill, environment}{Arguments to ggplot methods.}

\item{spcases}{Whether or not to plot special cases of perfect (positive and
negative) dependence and indpenendence. Defaults to \code{FALSE}.}

\item{plot.}{whether to plot to active graphics device.}

\item{ask}{Whether or not to ask before reusing the graphics device.}

\item{...}{Further arguments to be passed to methods.}
}
\value{
An object of class \code{chi} containing the following.

\item{chi}{Values of chi and their estimated upper and lower confidence
limits.} \item{chibar }{Values of chibar and their estimated upper and lower
confidence limits.} \item{quantile}{The quantiles at which chi and chi-bar
were evaluated.} \item{chiulb, chibarulb}{Upper and lower bounds for chi and
chi-bar.}
}
\description{
Compute measures of extremal dependence for 2 variables.
}
\details{
Computes the functions chi and chi-bar described by Coles, Heffernan and
Tawn (1999). The limiting values of these functions as the quantile
approaches 1 give an empirical measure of the type and strength of tail
dependendce exhibited by the data.

A limiting value of ChiBar equal to 1 indicates Asymptotic Dependence, in
which case the limiting value of Chi gives a measure of the strength of
dependence in this class.  A limiting value of ChiBar of less than 1
indicates Asymptotic Independence in which case Chi is irrelevant and the
limiting value of ChiBar gives a measure of the strength of dependence.

The plot and ggplot methods show the ChiBar and Chi functions.  In the case of the
confidence interval for ChiBar excluding the value 1 for all of the largest
quantiles, the plot of the Chi function is shown in grey.
}
\note{
When the data contain ties, the values of chi and chibar are
calculated by assigning distinct ranks to tied values using the \code{rank}
function with argument \code{ties.method = "first"}.  This results in the
values of chi and chibar being sensitive to the order in which the tied
values appear in the data.

The code is a fairly simple reorganization of code written by Janet E.
Heffernan and Alec Stephenson and which appears in the \code{chiplot}
function in the \code{evd} package.
}
\examples{


D <- liver[liver$dose == "D",]
chiD <- chi(D[, 5:6])
par(mfrow=c(1,2))
ggplot(chiD)

A <- liver[liver$dose == "A",]
chiA <- chi(A[, 5:6])
# here the limiting value of chi bar(u) lies away from one so the chi plot is
# not relevant and is plotted in grey
ggplot(chiA) 



}
\author{
Janet E. Heffernan, Alec Stephenson, Harry Southworth
}
\references{
S. Coles, J. E. Heffernan and J. A. Tawn, Dependence measures
for extreme values analyses, Extremes, 2, 339 -- 365, 1999.

A. G. Stephenson. evd: Extreme Value Distributions, R News, 2, 2002.
}
\seealso{
\code{\link{MCS}}, \code{\link{rank}}
}
\keyword{multivariate}

