% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_3_textEmbedReduce.R
\name{textEmbedReduce}
\alias{textEmbedReduce}
\title{Pre-trained dimension reduction (experimental)}
\usage{
textEmbedReduce(
  embeddings,
  n_dim = NULL,
  scalar =
    "https://raw.githubusercontent.com/adithya8/ContextualEmbeddingDR/master/models/fb20/scalar.csv",
  pca =
    "https://raw.githubusercontent.com/adithya8/ContextualEmbeddingDR/master/models/fb20/rpca_roberta_768_D_20.csv"
)
}
\arguments{
\item{embeddings}{(list) Embedding(s) - including, tokens, texts and/or word_types.}

\item{n_dim}{(numeric) Number of dimensions to reduce to.}

\item{scalar}{(string or matrix) Name or URL to scalar for standardizing the embeddings. If a URL, the function
first examines whether it has been downloaded before. The string should be to a csv file containing a matrix with
the pca weights for matrix multiplication. For more information see reference below.}

\item{pca}{(string or matrix) Name or URL to pca weights. If a URL, the function first examines whether it has been
downlaoded before. The string should be to a csv file containing a matrix. For more information see reference below.}
}
\value{
Returns embeddings with reduced number of dimensions.
}
\description{
Pre-trained dimension reduction (experimental)
}
\details{
To use this method please see and cite:\cr
Ganesan, A. V., Matero, M., Ravula, A. R., Vu, H., & Schwartz, H. A. (2021, June).
Empirical evaluation of pre-trained transformers for human-level nlp: The role of sample size and dimensionality.
In Proceedings of the conference. Association for Computational Linguistics. North American Chapter. Meeting (Vol. 2021, p. 4515).
NIH Public Access.\cr\cr
See also \href{https://adithya8.github.io/blog/paper/2021/04/15/Empirical-Evaluation.html}{Git-Hub Empirical-Evaluation}
}
\examples{
\dontrun{
embeddings <- textEmbedReduce(word_embeddings_4$texts)
}
}
\seealso{
\code{\link{textEmbed}}
}
