% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts_voices.R
\name{tts_voices}
\alias{tts_voices}
\alias{tts_amazon_voices}
\alias{tts_microsoft_voices}
\alias{tts_google_voices}
\title{Text to Speech Voices}
\usage{
tts_voices(service = c("amazon", "google", "microsoft"), ...)

tts_amazon_voices(...)

tts_microsoft_voices(...)

tts_google_voices(...)
}
\arguments{
\item{service}{service to use}

\item{...}{Additional arguments to service voice listings.}
}
\value{
A \code{data.frame} of language codes, voices, genders,
and language names
}
\description{
Text to Speech Voices
}
\examples{
if (tts_microsoft_auth()) {
tts_voices(service = "microsoft")
}
if (tts_google_auth()) {
tts_voices(service = "google")
}
if (requireNamespace("aws.polly", quietly = TRUE)) {
if (tts_amazon_auth()) {
tts_voices(service = "amazon")
}
}
}
