% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{JACCARD_DICE}
\alias{JACCARD_DICE}
\title{Jaccard or Dice similarity for text documents}
\usage{
JACCARD_DICE(token_list1 = NULL, token_list2 = NULL,
  method = "jaccard", threads = 1)
}
\arguments{
\item{token_list1}{a list of tokenized text documents (it should have the same length as the token_list2)}

\item{token_list2}{a list of tokenized text documents (it should have the same length as the token_list1)}

\item{method}{a character string specifying the similarity metric. One of 'jaccard', 'dice'}

\item{threads}{a numeric value specifying the number of cores to run in parallel}
}
\value{
a numeric vector
}
\description{
Jaccard or Dice similarity for text documents
}
\details{
The function calculates either the \emph{jaccard} or the \emph{dice} distance between pairs of tokenized text of two lists
}
\examples{

library(textTinyR)

lst1 = list(c('use', 'this', 'function', 'to'), c('either', 'compute', 'the', 'jaccard'))

lst2 = list(c('or', 'the', 'dice', 'distance'), c('for', 'two', 'same', 'sized', 'lists'))

out = JACCARD_DICE(token_list1 = lst1, token_list2 = lst2, method = 'jaccard', threads = 1)
}
