% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_emoticon.R
\name{replace_emoticon}
\alias{replace_emoticon}
\title{Replace Emoticons With Words}
\usage{
replace_emoticon(x, emoticon_dt = lexicon::hash_emoticons, ...)
}
\arguments{
\item{x}{The text variable.}

\item{emoticon_dt}{A \pkg{data.table} of emoticons (graphical representations)
and corresponding word meanings.}

\item{\ldots}{Other arguments passed to \code{.mgsub} (see
\code{sentimentr:::.mgsub} for details).}
}
\value{
Returns a vector of strings with emoticons replaced with word
equivalents.
}
\description{
Replaces emoticons with word equivalents.
}
\examples{
x <- c(
    "text from: http://www.webopedia.com/quick_ref/textmessageabbreviations_02.asp",
    "... understanding what different characters used in smiley faces mean:",
    "The close bracket represents a sideways smile  )",
    "Add in the colon and you have sideways eyes   :",
    "Put them together to make a smiley face  :)",
    "Use the dash -  to add a nose   :-)",
    "Change the colon to a semi-colon ; and you have a winking face ;)  with a nose  ;-)",
    "Put a zero 0 (halo) on top and now you have a winking, smiling angel 0;) with a nose 0;-)",
    "Use the letter 8 in place of the colon for sunglasses 8-)",
    "Use the open bracket ( to turn the smile into a frown  :-("
)

replace_emoticon(x)
}
\keyword{emoticon}

