% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{predict}
\alias{predict}
\alias{predict.LDA}
\alias{predict.jobjRef}
\alias{predict.tmTopicModel}
\title{predict for \code{tmTopicModel} object}
\usage{
\method{predict}{tmTopicModel}(object, x, stoplist_file = "en.txt",
  token_regexp = regexp_token, n_iterations = 100, sampling_interval = 10,
  burn_in = 10, random_seed = NULL, ...)

\method{predict}{LDA}(object, x, ...)

\method{predict}{jobjRef}(object, x, stoplist_file = "en.txt",
  token_regexp = regexp_token, n_iterations = 100, sampling_interval = 10,
  burn_in = 10, random_seed = NULL, ...)
}
\arguments{
\item{object}{A \code{tmTopicModel} or \code{LDA} or \code{jobjRef} object}

\item{x}{new data to predict probabilities of topics}

\item{stoplist_file}{file direcroty or vector of stopwords}

\item{token_regexp}{regular expression token}

\item{n_iterations}{mallet LDA topic model parameter}

\item{sampling_interval}{mallet LDA topic model parameter}

\item{burn_in}{mallet LDA topic model parameter}

\item{random_seed}{random seed}

\item{...}{other motdel arguments}
}
\description{
#' Function to predict topic model probabilities for existing topic model
#'
#' @param topic.model tmTopicModel obiect
#' @param x tmCorpus object
#' @param stoplist_file directory of file with stopwords
#' @param token_regexp regular expression patterns
#' @param burn_in parameter of mallet model
#' @param sampling_interval parameter of mallet model
#' @param n_iterations parameter of mallet model
#' @param random_seed parameter of mallet model
#' @param change predict structure so it fits normal
#'
#' @return returns the table of topic probabilities
#'
#' @export
predict <- function(topic.model, x, stoplist_file = "en.txt",
                    token_regexp = regexp_token, n_iterations = 100,
                    sampling_interval = 10, burn_in = 10, random_seed = NULL) {
  UseMethod("predict")
}
Function to predict topic model probabilities for an existing topic model. 
The code snippets for Mallet interface were derived from Andrew Goldstone's 
solution, posted at https://gist.github.com/agoldst/edcfd45b5ac371296b76
}
\references{
\url{https://gist.github.com/agoldst/edcfd45b5ac371296b76}
}

