% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{psi.weights}
\alias{psi.weights}
\alias{psi.weights.um}
\title{Psi weights of an AR(I)MA model}
\usage{
psi.weights(um, ...)

\method{psi.weights}{um}(um, lag.max = 10, var.psi = FALSE, ...)
}
\arguments{
\item{um}{an object of class \code{um}.}

\item{...}{additional arguments.}

\item{lag.max}{Largest MA(Inf) coefficient required.}

\item{var.psi}{logical. If TRUE the I polynomials is also inverted. If FALSE
it is ignored.}
}
\value{
A numeric vector.
}
\description{
\code{psi} computes the psi-weights of an AR(I)MA model.
}
\examples{
um1 <- um(i = "(1 - B)(1 - B^12)", ma = "(1 - 0.8B)(1 - 0.8B^12)")
psi.weights(um1)
psi.weights(um1, var.psi = TRUE)
}
