% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_from_datasets.R
\name{choose_from_datasets}
\alias{choose_from_datasets}
\title{Creates a dataset that deterministically chooses elements from datasets.}
\usage{
choose_from_datasets(datasets, choice_dataset, stop_on_empty_dataset = TRUE)
}
\arguments{
\item{datasets}{A non-empty list of tf.data.Dataset objects with compatible
structure.}

\item{choice_dataset}{A \code{tf.data.Dataset} of scalar \code{tf.int64} tensors
between \code{0} and \code{length(datasets) - 1}.}

\item{stop_on_empty_dataset}{If \code{TRUE}, selection stops if it encounters an
empty dataset. If \code{FALSE}, it skips empty datasets. It is recommended to
set it to \code{TRUE}. Otherwise, the selected elements start off as the user
intends, but may change as input datasets become empty. This can be
difficult to detect since the dataset starts off looking correct. Defaults
to \code{TRUE}.}
}
\value{
Returns a dataset that interleaves elements from datasets according
to the values of choice_dataset.
}
\description{
Creates a dataset that deterministically chooses elements from datasets.
}
\examples{
\dontrun{
datasets <- list(tensors_dataset("foo") \%>\% dataset_repeat(),
                 tensors_dataset("bar") \%>\% dataset_repeat(),
                 tensors_dataset("baz") \%>\% dataset_repeat())

# Define a dataset containing `[0, 1, 2, 0, 1, 2, 0, 1, 2]`.
choice_dataset <- range_dataset(0, 3) \%>\% dataset_repeat(3)
result <- choose_from_datasets(datasets, choice_dataset)
result \%>\% as_array_iterator() \%>\% iterate(function(s) s$decode()) \%>\% print()
# [1] "foo" "bar" "baz" "foo" "bar" "baz" "foo" "bar" "baz"
}
}
