% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{summary_image}
\alias{summary_image}
\alias{summary_image.ggplot}
\alias{summary_image.array}
\alias{summary_image.blob}
\alias{summary_image.raw}
\title{Creates a image summary}
\usage{
summary_image(img, ..., metadata = NULL, tag = NA)

\method{summary_image}{ggplot}(img, ..., width = 480, height = 480, metadata = NULL, tag = NA)

\method{summary_image}{array}(img, ..., metadata = NULL, tag = NA)

\method{summary_image}{blob}(img, ..., width, height, colorspace, metadata = NULL, tag = NA)

\method{summary_image}{raw}(img, ..., width, height, colorspace, metadata = NULL, tag = NA)
}
\arguments{
\item{img}{An object that can be converted to an image.}

\item{...}{Currently unused.}

\item{metadata}{A \code{metadata} object, as created with \code{\link[=summary_metadata]{summary_metadata()}}. In
most cases you don't need to change the default.}

\item{tag}{A tag that within the TensorBoard UI. See \code{\link[=log_event]{log_event()}} for other
ways of specifying the tag attribute.}

\item{width}{Width of the image.}

\item{height}{Height of the image.}

\item{colorspace}{Valid colorspace values are
\code{1 - grayscale},
\code{2 - grayscale + alpha},
\code{3 - RGB},
\code{4 - RGBA},
\code{5 - DIGITAL_YUV},
\code{6 - BGRA}}
}
\value{
An image summary that can be logged with \code{\link[=log_event]{log_event()}}.
}
\description{
Creates a image summary
}
\section{Methods (by class)}{
\itemize{
\item \code{summary_image(ggplot)}: Cretes an image summary from a ggplot2 graph object.
The \code{...} will be forwarded to \code{\link[grDevices:png]{grDevices::png()}}.

\item \code{summary_image(array)}: Creates an image from an R array. The array should be
numeric, with values between 0 and 1. Dimensions should be \verb{(batch, height, width, channels)}.

\item \code{summary_image(blob)}: Creates an image from \code{\link[blob:blob]{blob::blob()}} vctr of PNG encoded images,
(eg using \code{\link[png:writePNG]{png::writePNG()}}). \code{width}, \code{height} and \code{colorspace} are recycled
thus they can be a single scalar or a vector the same size of the images blob.

\item \code{summary_image(raw)}: Creates an image from a png encoded image. Eg, created
with \code{\link[png:writePNG]{png::writePNG()}}. In this case you need to provide \code{width}, \code{height} and
\code{colorspace} arguments.

}}
\examples{
tmp <- tempfile()
with_logdir(tmp, {
  summary_image(array(runif(100), dim = c(1,10, 10, 1)))
})
}
\seealso{
Other summary: 
\code{\link{summary_audio}()},
\code{\link{summary_histogram}()},
\code{\link{summary_scalar}()},
\code{\link{summary_text}()}
}
\concept{summary}
