% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_smooth_seasonal_state_space_model}
\alias{sts_smooth_seasonal_state_space_model}
\title{State space model for a smooth seasonal effect}
\usage{
sts_smooth_seasonal_state_space_model(
  num_timesteps,
  period,
  frequency_multipliers,
  drift_scale,
  initial_state_prior,
  observation_noise_scale = 0,
  initial_step = 0,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = NULL
)
}
\arguments{
\item{num_timesteps}{Scalar \code{integer} \code{Tensor} number of timesteps to model
with this distribution.}

\item{period}{positive scalar \code{float} \code{Tensor} giving the number of timesteps
required for the longest cyclic effect to repeat.}

\item{frequency_multipliers}{One-dimensional \code{float} \code{Tensor} listing the
frequencies (cyclic components) included in the model, as multipliers of
the base/fundamental frequency \code{2. * pi / period}. Each component is
specified by the number of times it repeats per period, and adds two
latent dimensions to the model. A smooth seasonal model that can
represent any periodic function is given by
\verb{frequency_multipliers = [1,2, ..., floor(period / 2)]}.
However, it is often desirable to enforce a
smoothness assumption (and reduce the computational burden) by dropping
some of the higher frequencies.}

\item{drift_scale}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{Tensor} indicating the standard deviation of the
latent state transitions.}

\item{initial_state_prior}{instance of \code{tfd$MultivariateNormal}
representing the prior distribution on latent states.  Must have
event shape \verb{[num_features]}.}

\item{observation_noise_scale}{Scalar (any additional dimensions are
treated as batch dimensions) \code{float} \code{Tensor} indicating the standard
deviation of the observation noise. Default value: \code{0.}.}

\item{initial_step}{scalar \code{integer} \code{Tensor} specifying the starting timestep.
Default value: \code{0}.}

\item{validate_args}{\code{logical}. Whether to validate input
with asserts. If \code{validate_args} is \code{FALSE}, and the inputs are
invalid, correct behavior is not guaranteed. Default value: \code{FALSE}.}

\item{allow_nan_stats}{\code{logical}. If \code{FALSE}, raise an
exception if a statistic (e.g. mean/mode/etc...) is undefined for any
batch member. If \code{TRUE}, batch members with valid parameters leading to
undefined statistics will return NaN for this statistic. Default value: \code{TRUE}.}

\item{name}{string prefixed to ops created by this class.
Default value: "LocalLinearTrendStateSpaceModel".}
}
\value{
an instance of \code{LinearGaussianStateSpaceModel}.
}
\description{
A state space model (SSM) posits a set of latent (unobserved) variables that
evolve over time with dynamics specified by a probabilistic transition model
\code{p(z[t+1] | z[t])}. At each timestep, we observe a value sampled from an
observation model conditioned on the current state, \code{p(x[t] | z[t])}. The
special case where both the transition and observation models are Gaussians
with mean specified as a linear function of the inputs, is known as a linear
Gaussian state space model and supports tractable exact probabilistic
calculations; see \code{tfp$distributions$LinearGaussianStateSpaceModel} for
details.
A smooth seasonal effect model is a special case of a linear Gaussian SSM. It
is the sum of a set of "cyclic" components, with one component for each
frequency:\preformatted{frequencies[j] = 2. * pi * frequency_multipliers[j] / period
}

Each cyclic component contains two latent states which we denote \code{effect} and
\code{auxiliary}. The two latent states for component \code{j} drift over time via:\preformatted{effect[t] = (effect[t-1] * cos(frequencies[j]) +
             auxiliary[t-] * sin(frequencies[j]) +
             Normal(0., drift_scale))
auxiliary[t] = (-effect[t-1] * sin(frequencies[j]) +
                auxiliary[t-] * cos(frequencies[j]) +
                Normal(0., drift_scale))
}
}
\details{
The \code{auxiliary} latent state only appears as a matter of construction and thus
its interpretation is not particularly important. The total smooth seasonal
effect is the sum of the \code{effect} values from each of the cyclic components.
The parameters \code{drift_scale} and \code{observation_noise_scale} are each (a batch
of) scalars. The batch shape of this \code{Distribution} is the broadcast batch
shape of these parameters and of the \code{initial_state_prior}.

Mathematical Details

The smooth seasonal effect model implements a
\code{tfp$distributions$LinearGaussianStateSpaceModel} with
\code{latent_size = 2 * len(frequency_multipliers)} and \code{observation_size = 1}.
The latent state is the concatenation of the cyclic latent states which themselves
comprise an \code{effect} and an \code{auxiliary} state. The transition matrix is a block diagonal
matrix where block \code{j} is:\preformatted{transition_matrix[j] =  [[cos(frequencies[j]), sin(frequencies[j])],
                         [-sin(frequencies[j]), cos(frequencies[j])]]
}

The observation model picks out the cyclic \code{effect} values from the latent state:\preformatted{observation_matrix = [[1., 0., 1., 0., ..., 1., 0.]]
observation_noise ~ Normal(loc=0, scale=observation_noise_scale)
}

For further mathematical details please see Harvey (1990).
}
\section{references}{

\itemize{
\item Harvey, A. Forecasting, Structural Time Series Models and the Kalman Filter. Cambridge: Cambridge University Press, 1990.
}
}

\seealso{
Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
