###################################################
### chunk number 1: 
###################################################
library(tgp)
library(akima)
library(maptree)


###################################################
### chunk number 2: 
###################################################
X <- seq(0,20,length=100)
XX <- seq(0,20,length=99)
Z <- (sin(pi*X/5) + 0.2*cos(4*pi*X/5)) * (X <= 9.6)
lin <- X>9.6; 
Z[lin] <- -1 + X[lin]/10
Z <- Z + rnorm(length(Z), sd=0.1)


###################################################
### chunk number 3: 
###################################################
sin.bgp <- bgp(X=X, Z=Z, XX=XX)


###################################################
### chunk number 4: bgp
###################################################
plot(sin.bgp, main='GP,')


###################################################
### chunk number 5: 
###################################################
sin.btlm <- btlm(X=X, Z=Z, XX=XX)


###################################################
### chunk number 6: btlm
###################################################
plot(sin.btlm, main='Linear CART,')


###################################################
### chunk number 7: btlmtrees
###################################################
tgp.trees(sin.btlm)


###################################################
### chunk number 8: 
###################################################
sin.btgp <- btgp(X=X, Z=Z, XX=XX)


###################################################
### chunk number 9: btgp
###################################################
plot(sin.btgp, main='treed GP,')


###################################################
### chunk number 10: btgptrees
###################################################
tgp.trees(sin.btgp)


###################################################
### chunk number 11: 
###################################################
sin.btgpllm <- btgpllm(X=X, Z=Z, XX=XX)


###################################################
### chunk number 12: btgpllm
###################################################
plot(sin.btgpllm, main='treed GP LLM,')


