% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graphs.R
\name{highlpoints}
\alias{highlpoints}
\title{Highlight highest similarities per point (highlpoints)}
\usage{
highlpoints(similarity, results, links = 3, col = "black",
  coordinates = FALSE, add = FALSE, xlim = NULL, cex.labels = 0.8,
  main = NULL)
}
\arguments{
\item{similarity}{Similarity matrix.}

\item{results}{Results of \code{smacofSym} or a set of coordinates.}

\item{links}{Number of similarities that should be drawn per point. 
Default is \code{3}.}

\item{col}{Color of the points in the graph. Default is \code{black}.}

\item{coordinates}{If \code{TRUE}, the input \code{results}  consist of a set 
of coordinates. Default is \code{FALSE}.}

\item{add}{If \code{TRUE}, the points will be added to the existing plot. 
Default is \code{FALSE}.}

\item{xlim}{Numeric vector giving the x coordinates range.}

\item{cex.labels}{Numeric value indicating font size of the labels.}

\item{main}{Title of the plot.}
}
\value{
Nothing.
}
\description{
\code{highlpoints} draws the highest similarities (per point) into an MDS graph.
}
\details{
This function is applicable to an MDS solution computed with the package 
'\code{smacof}' (Mair, De Leeuw, Borg, & Groenen) or a set of 
coordinates. It adds the \code{link} highest similarities per point, as 
indicated by the similarity matrix \code{similarity}, to the plot of the 
respective map. The links belonging to one point are displayed in 
the same color. If there is more than one similarity on the last rank 
\code{link}, all will be shown. The objects must occur in the same order in 
the results/ coodinates and the similarity matrix.
}
\examples{
## Calculating an MDS using the package 'smacof' and showing the 3 highest 
## similarities per point
data(SDG_coocurrence)
SDG_coocurrence <- SDG_coocurrence[,-2] # Drop second column
similarities <- simi(SDG_coocurrence, method = "as")
dissimilarities <- 1 - similarities
res <- smacof::smacofSym(dissimilarities, type = "ordinal")
highlpoints(similarities, res, links = 3, 
main = "3 Highest Similarities Per Point")
}
\seealso{
\code{\link[smacof]{smacofSym}}.
}
