% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_dims.R
\name{reduce_dims}
\alias{reduce_dims}
\title{Project a feature matrix into a low dimensional representation using PCA or t-SNE}
\usage{
reduce_dims(
  data,
  norm_method = c("zScore", "Sigmoid", "RobustSigmoid", "MinMax"),
  unit_int = FALSE,
  low_dim_method = c("PCA", "tSNE"),
  na_removal = c("feature", "sample"),
  perplexity = 10,
  seed = 123,
  ...
)
}
\arguments{
\item{data}{the \code{feature_calculations} object containing the raw feature matrix produced by \code{calculate_features}}

\item{norm_method}{\code{character} denoting the rescaling/normalising method to apply. Can be one of \code{"z-score"}, \code{"Sigmoid"}, \code{"RobustSigmoid"}, or \code{"MinMax"}. Defaults to \code{"z-score"}}

\item{unit_int}{\code{Boolean} whether to rescale into unit interval \code{[0,1]} after applying normalisation method. Defaults to \code{FALSE}}

\item{low_dim_method}{\code{character} specifying the low dimensional embedding method to use. Can be one of \code{"PCA"} or \code{"tSNE"}. Defaults to \code{"PCA"}}

\item{na_removal}{\code{character} defining the way to deal with NAs produced during feature calculation. Can be one of \code{"feature"} or \code{"sample"}. \code{"feature"} removes all features that produced any NAs in any sample, keeping the number of samples the same. \code{"sample"} omits all samples that produced at least one NA. Defaults to \code{"feature"}}

\item{perplexity}{\code{integer} denoting the perplexity hyperparameter to use if \code{low_dim_method} is \code{"t-SNE"}. Defaults to \code{10}}

\item{seed}{\code{integer} to fix R's random number generator to ensure reproducibility. Defaults to \code{123}}

\item{...}{arguments to be passed to either \code{stats::prcomp} or \code{Rtsne::Rtsne} depending on whether \code{"low_dim_method"} is \code{"PCA"} or \code{"t-SNE"}}
}
\value{
object of class \code{low_dimension}
}
\description{
Project a feature matrix into a low dimensional representation using PCA or t-SNE
}
\author{
Trent Henderson
}
