% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prev.R
\name{prev}
\alias{prev}
\title{Create prevalence vs abundance plot}
\usage{
prev(PS, taxon, n_taxa = 10, abund_threshold = 3,
  prev_threshold = ceiling(0.05 * phyloseq::nsamples(PS)))
}
\arguments{
\item{PS}{(required) A phyloseq object.}

\item{taxon}{Taxonomic level to be displayed. Defaults to 'Phylum'.}

\item{n_taxa}{The number of taxa to display at the given 'taxon' level.
The most abundant taxa at that group are selected. Defaults to 10.}

\item{abund_threshold}{User selected value for the lowest acceptable total
abundance. Defaults to 3.}

\item{prev_threshold}{User selected value for the lowest acceptable
prevalence. Defaults to 5% of the number of samples in the phyloseq object,
rounded up to the nearest integer.}
}
\value{
A ggplot object.
}
\description{
Function 'prev' (prevalence plot) tabulates the prevalence and abundance of
each taxa in a phyloseq object and plots the results as a ggplot object.
This may assist the user in determining what filtering and preprocessing
steps should be taken regarding the removal of low count taxa.
}
\details{
Low count taxa are often filtered from OTU tables to reduce possible
  error or noise. Examination of the raw (unfiltered) OTU table should be
  carried out to ensure that appropriate thresholds for prevalence (number of
  samples a taxa was observed in) and abundance (the total number of times a
  taxa was observed) are being selected. Function 'prev' plots each taxa
  according to thier prevalence and abundance within the dataset.
}
\examples{
\dontrun{
library(theseus)
data('WWTP_Impact')
p.prev <- prev(WWTP_Impact, taxon="Phylum", n_taxa=10)
p.prev
}

}
\references{
Callahan BJ, Sankaran K, Fukuyama JA et al. Bioconductor Workflow for
  Microbiome Data Analysis: from raw reads to community analyses.
  F1000Research 2016, 5:1492 (doi: 10.12688/f1000research.8986.2)
Perraudeau F, Risso D, Street K et al. Bioconductor workflow for single-cell
  RNA sequencing: Normalization, dimensionality reduction, clustering, and
  lineage inference. F1000Research 2017, 6:1158
  (doi:10.12688/f1000research.12122.1)
}
