% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownames.R
\name{rownames}
\alias{column_to_rownames}
\alias{has_rownames}
\alias{remove_rownames}
\alias{rownames}
\alias{rownames_to_column}
\title{Tools for working with row names}
\usage{
has_rownames(df)

remove_rownames(df)

rownames_to_column(df, var = "rowname")

column_to_rownames(df, var = "rowname")
}
\arguments{
\item{df}{A data frame}

\item{var}{Name of column to use for rownames.}
}
\description{
Generally, it is best to avoid row names, because they are basically a
character column with different semantics to every other column. These
functions allow to you detect if a data frame has row names
(\code{has_rownames}), remove them (\code{remove_rownames}), or convert
them back-and-forth between an explicit column (\code{rownames_to_column},
and \code{column_to_rownames}).
}
\examples{
has_rownames(mtcars)
has_rownames(iris)
has_rownames(remove_rownames(mtcars))

head(rownames_to_column(mtcars))

mtcars_tbl <- rownames_to_column(tbl_df(mtcars))
mtcars_tbl
column_to_rownames(mtcars_tbl)
}

