% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_expr}
\alias{bf_expr}
\title{Prepare caption with expression for Bayes Factor results}
\usage{
bf_expr(
  bf.df,
  k = 2L,
  output = "null",
  hypothesis.text = TRUE,
  caption = NULL,
  ...
)
}
\arguments{
\item{bf.df}{A dataframe containing two columns \code{log_e_bf01} (for evidence in
favor of null hypothesis) and \code{bf.prior}. If dataframe contains more than
two rows, only the first row will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{hypothesis.text}{Logical that decides whether the expression containing
result should have text to describe the hypothesis test being described.
For \code{output = "null"}, this is \code{"In favor of null: "}, otherwise
\code{"In favor of alternative: "}.}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{...}{Additional arguments (ignored).}
}
\description{
Convenience function to create an expression with Bayes
Factor results.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(tidyBF)

# dataframe containing results
bf.df <-
  bf_extractor(BayesFactor::correlationBF(
    x = iris$Sepal.Length,
    y = iris$Petal.Length
  )) \%>\%
  dplyr::mutate(.data = ., bf.prior = 0.707)

# creating caption (for null)
bf_expr(
  bf.df,
  output = "null",
  k = 3,
  caption = "Note: Iris dataset"
)

# creating caption (for alternative)
bf_expr(bf.df, output = "alternative")
}
}
