% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{plot_heatmap}
\usage{
plot_heatmap(
  .data,
  .horizontal,
  .vertical,
  .abundance,
  annotation = NULL,
  transform = NULL,
  palette_abundance = c("#440154FF", "#21908CFF", "#fefada"),
  palette_discrete = list(),
  palette_continuous = list(),
  ...
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> |}

\item{.horizontal}{The name of the column horizontally presented in the heatmap}

\item{.vertical}{The name of the column vertically presented in the heatmap}

\item{.abundance}{The name of the transcript/gene abundance column}

\item{annotation}{Vector of quotes}

\item{transform}{A function, used to tranform .value, for example log}

\item{palette_abundance}{A character vector, or a function for higher customisation (colorRamp2). This is the palette that will be used as gradient for abundance. If palette_abundance is a vector of hexadecimal colous, it should have 3 values. If you want more customisation, you can pass to palette_abundance a function, that is derived as for example `colorRamp2(c(-2, 0, 2), palette_abundance)`}

\item{palette_discrete}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical discrete annotations. The discrete classification of annotations depends on the column type of your input tibble (e.g., character and factor).}

\item{palette_continuous}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical continuous annotations. The continuous classification of annotations depends on the column type of your input tibble (e.g., integer, numerical, double).}

\item{...}{Further arguments to be passed to ComplexHeatmap::Heatmap}
}
\value{
A `ComplexHeatmap` object
}
\description{
plot_heatmap() takes a tbl object and easily produces a ComplexHeatmap plot, with integration with tibble and dplyr frameworks.
}
\details{
To be added.
}
