% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_LRT.R
\name{bootstrap_lrt}
\alias{bootstrap_lrt}
\title{Bootstrap the likelihood-ratio test statistic for mixture components}
\usage{
bootstrap_lrt(df, ..., n_profiles, model = 1)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles}{the number of profiles (or mixture components) to be estimated}

\item{model}{the mclust model to explore: 1 (varying means, equal variances, and residual covariances fixed to 0); 2 (varying means, equal variances and covariances; 3 (varying means and variances, covariances fixed to 0), 4 (varying means and covariances, equal variances; can only be specified in Mplus); 5 (varying means, equal variances, varying covariances); and 6 (varying means, variances, and covariances), in order least to most freely-estimated; see the introductory vignette for more information}
}
\description{
Bootstrap the likelihood-ratio test statistic for mixture components
}
\details{
Bootstrap the p-values for the likelihood-ratio test statistic for the number of mixture components for an mclust model.
}
\examples{
\dontrun{
d <- pisaUSA15
d <- dplyr::sample_n(d, 200)
bootstrap_lrt(d,
              broad_interest, enjoyment, self_efficacy)
}
}
