% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_LRT.R
\name{bootstrap_lrt}
\alias{bootstrap_lrt}
\title{Bootstrap the likelihood-ratio test statistic for mixture components}
\usage{
bootstrap_lrt(df, ..., n_profiles, variances = "fixed",
  covariances = "zero")
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles}{the number of profiles (or mixture components) to be estimated}

\item{variances}{how the variable variances are estimated; defaults to "equal" (to be constant across profiles); other option is "varying" (to be varying across profiles)}

\item{covariances}{how the variable covariances are estimated; defaults to "zero" (to not be estimated, i.e. for the covariance matrix to be diagonal); other options are "varying" (to be varying across profiles) and "equal" (to be constant across profiles)}
}
\description{
Bootstrap the likelihood-ratio test statistic for mixture components
}
\details{
Bootstrap the p-values for the likelihood-ratio test statistic for the number of mixture components for an mclust model.
}
\examples{
\dontrun{
d <- pisaUSA15
d <- dplyr::sample_n(d, 200)
bootstrap_lrt(d,
              broad_interest, enjoyment, self_efficacy)
}
}
