% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_emmeans_draws.R
\name{gather_emmeans_draws}
\alias{gather_emmeans_draws}
\alias{gather_emmeans_draws.default}
\alias{gather_emmeans_draws.emm_list}
\title{Extract a tidy data frame of draws of posterior distributions of "estimated marginal means" (emmeans/lsmeans) from
a Bayesian model fit.}
\usage{
gather_emmeans_draws(object, value = ".value", ...)

\method{gather_emmeans_draws}{default}(object, value = ".value", ...)

\method{gather_emmeans_draws}{emm_list}(object, value = ".value", grid = ".grid", ...)
}
\arguments{
\item{object}{An \code{emmGrid} object such as returned by
\code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} or \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.}

\item{value}{The name of the output column to use to contain the values of draws. Defaults to \code{".value"}.}

\item{...}{Additional arguments passed to the underlying method for the type of object given.}

\item{grid}{If \code{object} is an \code{\link[emmeans:emm_list-object]{emmeans::emm_list()}}, the name of the output column to use to contain the name of the
reference grid that a given row corresponds to. Defaults to \code{".grid"}.}
}
\value{
A tidy data frame of draws. The columns of the reference grid are returned as-is, with an
additional column called \code{.value} (by default) containing marginal draws. The resulting data
frame is grouped by the columns from the reference grid to make use of summary functions like
\code{\link[=point_interval]{point_interval()}} straightforward.

If \code{object} is an \code{\link[emmeans:emm_list-object]{emmeans::emm_list()}}, which contains estimates from different reference grids,
an additional column with the default name of \code{".grid"} is added to indicate the reference grid for each row in the output.
The name of this column is controlled by the \code{grid} argument.
}
\description{
Extract draws from the result of a call to \code{\link[emmeans:emmeans]{emmeans::emmeans()}} (formerly \code{lsmeans})
or \code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} applied to a Bayesian model.
}
\details{
\code{\link[emmeans:emmeans]{emmeans::emmeans()}} provides a convenient syntax for generating draws from "estimated marginal means" from a model,
and can be applied to various Bayesian models, like \link[rstanarm:stanreg-objects]{rstanarm::stanreg-objects} and
\code{\link[MCMCglmm:MCMCglmm]{MCMCglmm::MCMCglmm()}}. Given a \code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} object as returned by functions like
\code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} or \code{\link[emmeans:emmeans]{emmeans::emmeans()}} applied to a Bayesian model,
\code{gather_emmeans_draws} returns a tidy format data frame of draws from
the marginal posterior distributions generated by \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.
}
\examples{
\donttest{

library(dplyr)
library(magrittr)

if (
  require("brms", quietly = TRUE) &&
  require("emmeans", quietly = TRUE)
) {

  # Here's an example dataset with a categorical predictor (`condition`) with several levels:
  set.seed(5)
  n = 10
  n_condition = 5
  ABC =
    tibble(
      condition = rep(c("A","B","C","D","E"), n),
      response = rnorm(n * 5, c(0,1,2,1,-1), 0.5)
    )

  m = brm(response ~ condition, data = ABC,
    # 1 chain / few iterations just so example runs quickly
    # do not use in practice
    chains = 1, iter = 500)

  # Once we've fit the model, we can use emmeans() (and functions
  # from that package) to get whatever marginal distributions we want.
  # For example, we can get marginal means by condition:
  m \%>\%
    emmeans(~ condition) \%>\%
    gather_emmeans_draws() \%>\%
    median_qi()

  # or we could get pairwise differences:
  m \%>\%
    emmeans(~ condition) \%>\%
    contrast(method = "pairwise") \%>\%
    gather_emmeans_draws() \%>\%
    median_qi()

  # see the documentation of emmeans() for more examples of types of
  # contrasts supported by that packge.
}
}
}
\seealso{
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}
}
\author{
Matthew Kay
}
\keyword{manip}
