% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.R
\name{get_decennial}
\alias{get_decennial}
\title{Obtain data and feature geometry for the decennial Census}
\usage{
get_decennial(geography, variables, year = 2010, sumfile = "sf1",
  state = NULL, county = NULL, geometry = FALSE, output = "tidy",
  keep_geo_vars = FALSE, summary_var = NULL, key = NULL, ...)
}
\arguments{
\item{geography}{The geography of your data.}

\item{variables}{Character string or vector of character strings of variable
IDs.#'}

\item{year}{The year for which you are requesting data.  1990, 2000, and 2010 are available.}

\item{sumfile}{The Census summary file.  Defaults to sf1; the function will look in sf3 if it
cannot find a variable in sf1.}

\item{state}{The state for which you are requesting data. State
names, postal codes, and FIPS codes are accepted.
Defaults to NULL.}

\item{county}{The county for which you are requesting data. County names and
FIPS codes are accepted. Must be combined with a value supplied
to `state`.  Defaults to NULL.}

\item{geometry}{if FALSE (the default), return a regular tibble of ACS data.
if TRUE, uses the tigris package to return an sf tibble
with simple feature geometry in the `geometry` column.  state, county, tract, and block group are
supported for 1990 through 2010; block and ZCTA geometry are supported for 2000 and 2010.}

\item{output}{One of "tidy" (the default) in which each row represents an
enumeration unit-variable combination, or "wide" in which each
row represents an enumeration unit and the variables are in the
columns.}

\item{keep_geo_vars}{if TRUE, keeps all the variables from the Census
shapefile obtained by tigris.  Defaults to FALSE.}

\item{summary_var}{Character string of a "summary variable" from the decennial Census
to be included in your output. Usually a variable (e.g. total population)
that you'll want to use as a denominator or comparison.}

\item{key}{Your Census API key.
Obtain one at \url{http://api.census.gov/data/key_signup.html}}

\item{...}{Other keyword arguments}
}
\value{
a tibble or sf tibble of decennial Census data
}
\description{
Obtain data and feature geometry for the decennial Census
}
\examples{
\dontrun{
# Plot of race/ethnicity by county in Illinois for 2010
library(tidycensus)
library(tidyverse)
library(viridis)
census_api_key("YOUR KEY GOES HERE")
vars10 <- c("P0050003", "P0050004", "P0050006", "P0040003")

il <- get_decennial(geography = "county", variables = vars10, year = 2010,
                    summary_var = "P0010001", state = "IL", geometry = TRUE) \%>\%
  mutate(pct = 100 * (value / summary_value))

ggplot(il, aes(fill = pct, color = pct)) +
  geom_sf() +
  facet_wrap(~variable)


}
}
