% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_nhpp.R
\name{plot_intensity}
\alias{plot_intensity}
\title{Plot the intensity of an NHPP fit}
\usage{
plot_intensity(x, ...)
}
\arguments{
\item{x}{An NHPP \code{model} returned by \code{\link[=fit_nhpp]{fit_nhpp()}}}

\item{...}{currently ignored}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Plot the intensity of an NHPP fit
}
\examples{
# Plot the estimated intensity function
plot_intensity(fit_nhpp(DataCPSim, tau = 826))

# Segment a time series using PELT
mod <- segment(bogota_pm, method = "pelt")

# Plot the estimated intensity function for the NHPP model using the 
# changepoints found by PELT
plot_intensity(fit_nhpp(bogota_pm, tau = changepoints(mod)))

}
