% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownames.R
\name{rn_col}
\alias{rn_col}
\alias{col_rn}
\title{Tools for working with row names}
\usage{
rn_col(.data, var = "rowname")

col_rn(.data, var = "rowname")
}
\arguments{
\item{.data}{A data.frame.}

\item{var}{Name of column to use for rownames.}
}
\value{
\code{rn_col} returns a data.table,
\code{col_rn} returns a data frame.
}
\description{
The enhanced data.frame, including tibble and data.table, do not
support row names. To link to some base r facilities, there should be functions
to save information in row names. These functions are analogous to
\code{rownames_to_column} and \code{column_to_rownames} in \pkg{tibble}.
}
\examples{

 mtcars \%>\% rn_col()
 mtcars \%>\% rn_col("rn")

 mtcars \%>\% rn_col() -> new_mtcars

 new_mtcars \%>\% col_rn() -> old_mtcars
 old_mtcars
 setequal(mtcars,old_mtcars)
}
