% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{realtime_dd}
\alias{realtime_dd}
\title{Download a tibble of realtime discharge data from the Meteorological Service of Canada datamart}
\format{A tibble with 8 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{PROV_TERR_STATE_LOC}{The province, territory or state in which the station is located}
  \item{Date}{Observation date and time. Formatted as a POSIXct class as UTC for consistency.}
  \item{Parameter}{Parameter being measured. Only possible values are FLOW and LEVEL}
  \item{Value}{Value of the measurement. If Parameter equals FLOW the units are m^3/s. If Parameter equals LEVEL the 
  units are metres.}
  \item{Grade}{future use}
  \item{Symbol}{future use}
  \item{Code}{quality assurance/quality control flag for the discharge}
}}
\usage{
realtime_dd(station_number = NULL, prov_terr_state_loc)
}
\arguments{
\item{station_number}{Water Survey of Canada station number. If this argument is omitted from the function call, the value of \code{prov_terr_state_loc}
is returned.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted from the function call, the value of \code{station_number}
is returned.}
}
\value{
A tibble of water flow and level values.
}
\description{
Download realtime discharge data from the Meteorological Service of Canada (MSC) datamart. The function will prioritize
downloading data collected at the highest resolution. In instances where data is not available at high (hourly or higher) resolution
daily averages are used. Currently, if a station does not exist or is not found, no data is returned.
}
\examples{
\dontrun{
## Download from multiple provinces
realtime_dd(station_number=c("01CD005","08MF005"))

# To download all stations in Prince Edward Island:
realtime_dd(prov_terr_state_loc = "PE")
}

}
\seealso{
Other realtime functions: \code{\link{realtime_stations}}
}
