# Copyright 2017 Province of British Columbia
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and limitations under the License.

#' @references
#'
#' To download the latest version of hydat please:
#'   - use the [download_hydat()] function.
#'   - If that fails you can download directly from this link: [https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/](https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/)
#'
#' For more information on tidy data please see
#'
#'  - Wickham, Hadley. 2014. Tidy Data. The Journal of Statistical Software. 59. \doi{10.18637/jss.v059.i10}
#'  - tidy data vignette: [https://CRAN.R-project.org/package=tidyr/vignettes/tidy-data.html](https://CRAN.R-project.org/package=tidyr/vignettes/tidy-data.html)
#'
#'  For more information on HYDAT and ECCC data sources
#'
#'    - Please see this description of the [database](https://www.canada.ca/en/environment-climate-change/services/water-overview/quantity/monitoring/survey/data-products-services/national-archive-hydat.html)
#'    - This page is landing page for technical description of [HYDAT](https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/)
#'    - This pdf links to a document that outlines database table [definitions](https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/HYDAT_Definition_EN.pdf)
#'    - This FAQ provides a helpful list of ECCC data source [questions](https://wateroffice.ec.gc.ca/contactus/faq_e.html)
#'
#'
#' @keywords internal
"_PACKAGE"
