% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_lengths.R
\name{json_lengths}
\alias{json_lengths}
\title{Compute the length of JSON data}
\usage{
json_lengths(.x, column.name = "length")
}
\arguments{
\item{.x}{a json string or \code{\link{tbl_json}} object}

\item{column.name}{the name to specify for the length column}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
When investigating JSON data it can be helpful to identify the lengths of the
JSON objects or arrays, especialy when they are 'ragged' across documents.
The \code{json_lengths} function adds a column (default name \code{"length"})
that contains the 'length' of the JSON associated with each row. For objects,
this will be equal to the number of name-value pairs. For arrays, this will
be equal to the length of the array. All scalar values will be of length 1,
and null will have length 0.
}
\examples{

# A simple example
json <- c('[1, 2, 3]', '{"k1": 1, "k2": 2}', '1', 'null')

# Complexity is larger than length for nested objects
json \%>\% json_lengths

# Worldbank objcts are either length 7 or 8
library(magrittr)
worldbank \%>\% json_lengths \%$\% table(length)

# All commits are length 8
commits \%>\% gather_array \%>\% json_lengths \%$\% table(length)
}
\seealso{
\code{\link{json_complexity}} to compute the recursive length of
         each value
}
