% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming_callback.R
\name{generate_callback_function}
\alias{generate_callback_function}
\title{Generate API-Specific Callback Function for Streaming Responses}
\usage{
generate_callback_function(.api)
}
\arguments{
\item{.api}{A character string indicating the API type. Supported values are
\code{"claude"}, \code{"ollama"}, and \code{"chatgpt"}.}
}
\value{
A function that serves as a callback to handle streaming responses
from the specified API. The callback function processes the raw data, updates
the \code{.tidyllm_stream_env$stream} object, and prints the streamed content to the console.
The function returns \code{TRUE} if streaming should continue, and \code{FALSE} when
streaming is finished.
}
\description{
This function generates a callback function that processes streaming responses
from different language model APIs. The callback function is specific to the
API provided (\code{claude}, \code{ollama}, or \code{chatgpt}) and processes incoming data streams,
printing the content to the console and updating a global environment for further use.
}
\details{
\itemize{
\item \strong{For Claude API}: The function processes event and data lines, and handles the \code{message_start}
and \code{message_stop} events to control streaming flow.
\item \strong{For Ollama API}: The function directly parses the stream content as JSON and extracts the
\code{message$content} field.
\item \strong{For ChatGPT API}: The function handles JSON data streams and processes content deltas.
It stops processing when the \verb{[DONE]} message is encountered.
}
}
