% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_openai.R
\name{check_openai_batch}
\alias{check_openai_batch}
\title{Check Batch Processing Status for OpenAI Batch API}
\usage{
check_openai_batch(
  .llms = NULL,
  .batch_id = NULL,
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects.}

\item{.batch_id}{A manually set batch ID.}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it (default: FALSE).}

\item{.max_tries}{Maximum retries to perform the request (default: 3).}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}
}
\value{
A tibble with information about the status of batch processing.
}
\description{
This function retrieves the processing status and other details of a specified OpenAI batch ID
from the OpenAI Batch API.
}
