% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message_retrieval.R
\name{get_logprobs}
\alias{get_logprobs}
\title{Retrieve Log Probabilities from Assistant Replies}
\usage{
get_logprobs(.llm, .index = NULL)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the message history.}

\item{.index}{A positive integer specifying which assistant reply's log probabilities to extract.
If \code{NULL} (default), log probabilities for all replies are returned.}
}
\value{
A tibble containing log probabilities for the specified assistant reply or all replies.
}
\description{
Extracts token log probabilities from assistant replies within an \code{LLMMessage} object.
Each row represents a token with its log probability and top alternative tokens.
}
\details{
An empty tibble is output if no logprobs were requested. Currently only works with \code{openai_chat()}

Columns include:
\itemize{
\item \code{reply_index}: The index of the assistant reply in the message history.
\item \code{token}: The generated token.
\item \code{logprob}: The log probability of the generated token.
\item \code{bytes}: The byte-level encoding of the token.
\item \code{top_logprobs}: A list column containing the top alternative tokens with their log probabilities.
}
}
\seealso{
\code{\link[=get_metadata]{get_metadata()}}
}
