% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{geom_smooth_ci}
\alias{geom_smooth_ci}
\title{Smooths and confidence intervals.}
\usage{
geom_smooth_ci(group = NULL, ci_z = 1.96, ci_alpha = 0.1, data = NULL, ...)
}
\arguments{
\item{group}{The optional grouping factor.}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for 95 percent CI).}

\item{ci_alpha}{Transparency value of CIs (the default is \code{0.1}).}

\item{data}{The data to be displayed in this layer. If \code{NULL}, it is inherited.}

\item{...}{Arguments passed to \code{geom_path()}.}
}
\description{
It provides a `geom` for plotting GAM smooths with confidence intervals from the output of \link[tidymv]{predict_gam}. It inherits the following aesthetics from a call to \code{ggplot}:
  \itemize{
    \item The term defining the x-axis.
    \item The fitted values (the \code{fit} column in the tibble returned by \link[tidymv]{predict_gam}).
    \item The standard error of the fit (the \code{se.fit} column in the tibble returned by \link[tidymv]{predict_gam}).
  }
}
\examples{
library(mgcv)
library(ggplot2)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac), data = data)

# get predictions
p <- predict_gam(model)

# plot smooths and confidence intervals
ggplot(p, aes(x2, fit)) + geom_smooth_ci(fac)

}
