% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_vl_eligible.R
\name{tx_vl_eligible}
\alias{tx_vl_eligible}
\title{Subset Clients who are Eligible for Viral Load}
\usage{
tx_vl_eligible(
  data,
  ref = get("Sys.Date")(),
  states = .s,
  facilities = .f,
  status = "calculated",
  sample = FALSE
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr().}

\item{ref}{Date provided in ISO8601 format ("yyyy-mm-dd"). Used to
determine clients who are eligible for viral load and should have a
documented result. The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{sample}{Logical (TRUE or FALSE) indicating whether all clients eligible for
viral load test should be filtered irrespective of their eligibility for sample
collection or only those due for sample collection.}
}
\value{
tx_vl_eligible
}
\description{
Generates the line-list of clients who have been (or would have been) on ARV
medications for at least 6 months from the reference date. The default
reference date is the date of analysis.
}
\examples{
tx_vl_eligible(ndr_example)

# Determine clients who are going to be eligible for VL by the end of Q2 of FY21
tx_vl_eligible(ndr_example,
  ref = "2021-03-31"
)

# Subset clients from "State 1" who are due for viral load in Q2 of FY21
tx_vl_eligible(ndr_example,
  ref = "2021-03-31",
  states = c("State 1", "State 3"),
  sample = TRUE
)
}
