% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-geoms.R
\docType{data}
\name{geom_ribbonh}
\alias{geom_ribbonh}
\alias{GeomRibbonh}
\alias{geom_areah}
\alias{GeomAreah}
\title{Vertical ribbons and area plots}
\format{
An object of class \code{GeomRibbonh} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.

An object of class \code{GeomAreah} (inherits from \code{GeomRibbonh}, \code{Geom}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
geom_ribbonh(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

GeomRibbonh

geom_areah(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "stackv",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

GeomAreah
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{See
\link[ggplot2:geom_ribbon]{geom_ribbon}.}
}
\description{
Vertical ribbons and area plots
}
\examples{
library(ggplot2)

# Generate data
huron <- data.frame(year = 1875:1972, level = as.vector(LakeHuron))
h <- ggplot(huron, aes(y = year))

h + geom_ribbonh(aes(xmin=0, xmax=level))
h + geom_areah(aes(x = level))

# Add aesthetic mappings
h +
  geom_ribbonh(aes(xmin = level - 1, xmax = level + 1), fill = "grey70") +
  geom_lineh(aes(x = level))

}
\keyword{datasets}
