% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_providers.R
\name{llm_provider_groq}
\alias{llm_provider_groq}
\title{Create a new Groq LLM provider}
\usage{
llm_provider_groq(
  parameters = list(model = "llama-3.1-8b-instant", stream = TRUE),
  verbose = getOption("tidyprompt.verbose", TRUE),
  url = "https://api.groq.com/openai/v1/chat/completions",
  api_key = Sys.getenv("GROQ_API_KEY")
)
}
\arguments{
\item{parameters}{A named list of parameters. Currently the following parameters are required:
\itemize{
\item model: The name of the model to use
\item stream: A logical indicating whether the API should stream responses
}

Additional parameters are appended to the request body; see the Groq API
documentation for more information: https://console.groq.com/docs/api-reference#chat-create}

\item{verbose}{A logical indicating whether the interaction with the LLM provider
should be printed to the console}

\item{url}{The URL to the Groq API endpoint for chat completion}

\item{api_key}{The API key to use for authentication with the Groq API}
}
\value{
A new \linkS4class{llm_provider} object for use of the Groq API
}
\description{
This function creates a new \linkS4class{llm_provider} object that interacts with the Groq API.
}
\examples{
# Various providers:
ollama <- llm_provider_ollama()
openai <- llm_provider_openai()
openrouter <- llm_provider_openrouter()
mistral <- llm_provider_mistral()
groq <- llm_provider_groq()
xai <- llm_provider_xai()
gemini <- llm_provider_google_gemini()

# Initialize with settings:
ollama <- llm_provider_ollama(
  parameters = list(
    model = "llama3.2:3b",
    stream = TRUE
  ),
  verbose = TRUE,
  url = "http://localhost:11434/api/chat"
)

# Change settings:
ollama$verbose <- FALSE
ollama$parameters$stream <- FALSE
ollama$parameters$model <- "llama3.1:8b"

\dontrun{
  # Try a simple chat message with '$complete_chat()':
  response <- ollama$complete_chat("Hi!")
  response
  # $role
  # [1] "assistant"
  #
  # $content
  # [1] "How's it going? Is there something I can help you with or would you like
  # to chat?"
  #
  # $http
  # Response [http://localhost:11434/api/chat]
  # Date: 2024-11-18 14:21
  # Status: 200
  # Content-Type: application/json; charset=utf-8
  # Size: 375 B

  # Use with send_prompt():
  "Hi" |>
    send_prompt(ollama)
  # [1] "How's your day going so far? Is there something I can help you with or
  # would you like to chat?"
}
}
\seealso{
Other llm_provider: 
\code{\link{llm_provider-class}},
\code{\link{llm_provider_google_gemini}()},
\code{\link{llm_provider_mistral}()},
\code{\link{llm_provider_ollama}()},
\code{\link{llm_provider_openai}()},
\code{\link{llm_provider_openrouter}()},
\code{\link{llm_provider_xai}()}
}
\concept{llm_provider}
