% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistent_chat.R
\name{persistent_chat-class}
\alias{persistent_chat-class}
\title{PersistentChat R6 class}
\description{
A class for managing a persistent chat with a large language model (LLM).

While 'tidyprompt' is primariy focused on automatic interactions with
LLMs through \code{\link[=send_prompt]{send_prompt()}} using a \linkS4class{tidyprompt} object with
\code{\link[=prompt_wrap]{prompt_wrap()}}, this class may be useful for having a manual conversation
with an LLM. (It may specifically be used to continue a chat history which was
returned by \code{\link[=send_prompt]{send_prompt()}} with \code{return_mode = "full"}.)
}
\examples{
# Create a persistent chat with any LLM provider
chat <- `persistent_chat-class`$new(llm_provider_ollama())

\dontrun{
  chat$chat("Hi! Tell me about Twente, in a short sentence?")
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # Hi! Tell me about Twente, in a short sentence?
  # --- Receiving response from LLM provider: ---
  # Twente is a charming region in the Netherlands known for its picturesque
  # countryside and vibrant culture!

  chat$chat("How many people live there?")
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # How many people live there?
  # --- Receiving response from LLM provider: ---
  # The population of Twente is approximately 650,000 inhabitants, making it one of
  # the largest regions in the Netherlands.

  # Access the chat history:
  chat$chat_history

  # Reset the chat history:
  chat$reset_chat_history()

  # Continue a chat from the result of `send_prompt()`:
  result <- "Hi there!" |>
    answer_as_integer() |>
    send_prompt(return_mode = "full")
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # Hi there!
  #
  # You must answer with only an integer (use no other characters).
  # --- Receiving response from LLM provider: ---
  # 42
  chat <- `persistent_chat-class`$new(llm_provider_ollama(), result$chat_history)
  chat$chat("Why did you choose that number?")
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # Why did you choose that number?
  # --- Receiving response from LLM provider: ---
  # I chose the number 42 because it's a reference to Douglas Adams' science fiction
  # series "The Hitchhiker's Guide to the Galaxy," in which a supercomputer named
  # Deep Thought is said to have calculated the "Answer to the Ultimate Question of
  # Life, the Universe, and Everything" as 42.
}

}
\seealso{
\linkS4class{llm_provider} \code{\link[=chat_history]{chat_history()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{chat_history}}{A \code{\link[=chat_history]{chat_history()}} object}

\item{\code{llm_provider}}{A \linkS4class{llm_provider} object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistentChat-new}{\code{persistent_chat-class$new()}}
\item \href{#method-PersistentChat-chat}{\code{persistent_chat-class$chat()}}
\item \href{#method-PersistentChat-reset_chat_history}{\code{persistent_chat-class$reset_chat_history()}}
\item \href{#method-PersistentChat-clone}{\code{persistent_chat-class$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistentChat-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistentChat-new}{}}}
\subsection{Method \code{new()}}{
Initialize the PersistentChat object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{persistent_chat-class$new(llm_provider, chat_history = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{llm_provider}}{A \linkS4class{llm_provider} object}

\item{\code{chat_history}}{(optional) A \code{\link[=chat_history]{chat_history()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The initialized PersistentChat object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistentChat-chat"></a>}}
\if{latex}{\out{\hypertarget{method-PersistentChat-chat}{}}}
\subsection{Method \code{chat()}}{
Add a message to the chat history and get a response from the LLM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{persistent_chat-class$chat(msg, role = "user", verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Message to add to the chat history}

\item{\code{role}}{Role of the message}

\item{\code{verbose}}{Whether to print the interaction to the console}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The response from the LLM
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistentChat-reset_chat_history"></a>}}
\if{latex}{\out{\hypertarget{method-PersistentChat-reset_chat_history}{}}}
\subsection{Method \code{reset_chat_history()}}{
Reset the chat history
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{persistent_chat-class$reset_chat_history()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistentChat-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistentChat-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{persistent_chat-class$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
