% Generated by roxygen2 (4.0.2): do not edit by hand
\name{expand}
\alias{expand}
\title{Expand data frame to include all combinations of levels.}
\usage{
expand(data, ...)
}
\arguments{
\item{data}{A data frame}

\item{...}{Specification of columns to expand. These can either
be bare column names, or transformations of a column.}
}
\description{
Expand data frame to include all combinations of levels.
}
\examples{
expand(mtcars, vs, cyl)
expand(mtcars, cyl, mpg = seq_range(mpg, 2))
expand(mtcars, cyl, mpg = seq_range(mpg, 5))

df <- data.frame(a = c(1, 2, 5), b = c(3, 5, 3), c = c(1, 2, 3))
expand(df)
expand(df, a, b)
expand(df, a, c)
expand(df, b, c)
}
\seealso{
\code{\link{expand_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

