% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_na.r
\name{drop_na}
\alias{drop_na}
\title{Drop rows containing missing values}
\usage{
drop_na(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of variables to consider while dropping rows.
If empty, consider all variables. Use bare variable names. Select all
 variables between x and z with \code{x:z}, exclude y with \code{-y}.
 For more options, see the \link[dplyr]{select} documentation.}
}
\description{
Drop rows containing missing values
}
\examples{
library(dplyr)
df <- data_frame(x = c(1, 2, NA), y = c("a", NA, "b"))
df \%>\% drop_na()
df \%>\% drop_na(x)
}
\seealso{
\code{\link{drop_na_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

