% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{join_features}
\alias{join_features}
\alias{join_features,Seurat-method}
\title{Extract and join information for features.}
\usage{
\S4method{join_features}{Seurat}(
  .data,
  features = NULL,
  all = FALSE,
  exclude_zeros = FALSE,
  shape = "long",
  assay = NULL,
  slot = "data",
  ...
)
}
\arguments{
\item{.data}{A Seurat object}

\item{features}{A vector of feature identifiers to join}

\item{all}{If TRUE return all}

\item{exclude_zeros}{If TRUE exclude zero values in long format}

\item{shape}{Format of the returned table "long" or "wide"}

\item{assay}{assay name to extract feature abundance}

\item{slot}{slot in the assay to extract feature abundance}

\item{...}{the other arguments}
}
\value{
An object containing the information.for the specified features

An object containing the information.for the specified features
}
\description{
join_features() extracts and joins information for specified features
}
\details{
This function extracts information for specified features and returns the information in either long or wide format.
}
\examples{

data("pbmc_small")
pbmc_small \%>\% 
join_features(features = c("HLA-DRA", "LYZ"))

}
