% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typify.R
\name{typify}
\alias{typify}
\alias{typify.sq}
\title{Set type of an sq object}
\usage{
typify(x, dest_type, ...)

\method{typify}{sq}(x, dest_type, ..., NA_letter = getOption("tidysq_NA_letter"))
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{dest_type}{[\code{character(1)}]\cr
The name of destination type - one of \code{"dna_bsc"}, \code{"dna_ext"},
\code{"rna_bsc"}, \code{"rna_ext"}, \code{"ami_bsc"} and \code{"ami_ext"}.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
\code{\link[=sq-class]{sq}} object with the same letters as input
\code{x}, but with type as specified in \code{dest_type}.
}
\description{
Sets sequence type (and, consequently, alphabet attribute) to
one of \strong{ami}, \strong{dna} or \strong{rna} types.
}
\details{
Sometimes functions from I/O module return sequences of incorrect type, most
often \strong{unt} (which indicates no type). It happens mostly whenever
there are letters that don't fit into target alphabet. After replacing wrong
letters with correct ones with \code{\link{substitute_letters}} the user has
sequences of type \strong{atp}, even if their alphabet is contained in the
target one. At the same time, many functions demand sequences to be of
standard type (i.e. \strong{ami}, \strong{dna} or \strong{rna}) or behave
differently for these.

\code{typify()} is used to help with these situations by allowing the user
to convert their sequences to target type. There are some conditions that
must be met to use this function. The most important is that typified
\code{sq} object must not contain invalid letters. If this condition is not
satisfied, an error is thrown.

If \code{dest_type} is equal to type of \code{sq}, function simply returns
input value.
}
\examples{
# Constructing sq object with strange characters (type will be set to "unt"):
sq_unt <- sq(c("&VPLG&#", "##LCG"))

# Substituting letters with "X", which stands for unknown amino acid:
sq_sub <- substitute_letters(sq_unt, c(`&` = "X", `#` = "X"))

# Setting extended amino acid type (only extended one has "X" letter):
typify(sq_sub, "ami_ext")

}
\seealso{
Functions that manipulate type of sequences:
\code{\link{find_invalid_letters}()},
\code{\link{is.sq}()},
\code{\link{sq_type}()},
\code{\link{substitute_letters}()}
}
\concept{type_functions}
