% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_glm.R
\name{report_glm}
\alias{report_glm}
\title{Report method for generalized linear models}
\usage{
report_glm(identifier, group = NULL, term = NULL, term_nr = NULL,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{group}{A character string indicating the group containing the
statistics you want to report.}

\item{term}{A character string indicating the term you want to report.}

\item{term_nr}{A number indicating the term you want to report.}

\item{results}{A tidystats list.}
}
\description{
Function to report a generalized linear models in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default results list
options(tidystats_list = results)

# Report results
report("glm_gaussian", term = "Prewt")
report("glm_gamma", term = "log(u)")
report("glm_poisson", term_nr = 2)

}
